/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class JavaDiet
extends MIDlet
implements CommandListener,
ItemStateListener {
    private Display display = Display.getDisplay((MIDlet)this);
    private Form openingForm;
    private Form helpForm;
    private Form resetForm;
    private Form reportsForm;
    private Form textualReportForm;
    private Form graphicReportForm;
    private Form addCaloriesForm;
    private Form addTypeForm;
    private Form delTypeForm;
    private Image img1;
    private Image img2;
    private ImageItem imgItem1;
    private ImageItem imgItem2;
    private ImageItem graphImgItem;
    private List mainList;
    private StringItem resetSI;
    private StringItem openingSI;
    private StringItem helpSI;
    private StringItem reportSI;
    private TextField nameTF;
    private TextField caloriesTF;
    private DateField fromDF;
    private DateField toDF;
    private Calendar calendar;
    private Canvas graphicReportCanvas;
    private Command helpCommand;
    private Command nextCommand;
    private Command backCommand;
    private Command saveCommand;
    private Command delCommand;
    private Command addCommand;
    private Command okCommand;
    private Command mainCommand;
    private String[] types;
    private JavaDietEngine javaDietEngine = new JavaDietEngine();
    private ChoiceGroup foodTypesCG;
    private ChoiceGroup foodTypesCGCopy;
    private ChoiceGroup reportsCG;
    private ChoiceGroup amountCG;
    private ChoiceGroup foodDrinkCG;
    private Alert alertMessage;
    AnimationThread animationThread;

    public JavaDiet() throws Exception {
        this.calendar = Calendar.getInstance();
        this.alertMessage = new Alert("System Message");
        this.nextCommand = new Command("Next", 4, 1);
        this.helpCommand = new Command("Help", 4, 1);
        this.backCommand = new Command("Back", 4, 1);
        this.delCommand = new Command("Del", 4, 1);
        this.addCommand = new Command("Add", 4, 1);
        this.saveCommand = new Command("Save", 4, 1);
        this.okCommand = new Command("Ok", 4, 1);
        this.mainCommand = new Command("Main", 4, 1);
        this.openingForm = new Form("");
        try {
            this.img1 = Image.createImage((String)"/JavaDiet1.png");
            this.img2 = Image.createImage((String)"/JavaDiet2.png");
            this.imgItem1 = new ImageItem("", this.img1, 0, "[JavaDiet]");
            this.imgItem2 = new ImageItem("", this.img2, 0, "[JavaDiet]");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.openingForm.append((Item)this.imgItem1);
        this.animationThread = new AnimationThread();
        this.openingSI = new StringItem("Java Diet v1.1Beta\nwas developed by", "\nJACADO\nwww.jacado.com\nThis software is provided \"AS IS\", without warranty of any kind. In no event, shell we be liable for any claim, damages or other liability. Copyright(c)2001 Haim Michael, JACADO & ZINDELL Ltd. All rights reserved.");
        this.openingForm.append((Item)this.openingSI);
        this.openingForm.addCommand(this.nextCommand);
        this.openingForm.addCommand(this.helpCommand);
        this.openingForm.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.openingForm);
        System.out.println("openingForm was created");
        this.helpForm = new Form("Help");
        String str = "\nThis midlet allows you to manage your daily calories consumption. This midlet enables you adding new types of foods as well as creating reports that display your calories consumption. ";
        this.helpSI = new StringItem("Instructions", str);
        this.helpForm.append((Item)this.helpSI);
        this.helpForm.addCommand(this.backCommand);
        this.helpForm.setCommandListener((CommandListener)this);
        System.out.println("helpForm was created");
        this.mainList = new List("Main Menu", 3, new String[]{"Add Calories", "Reports", "Reset", "Add Food Type", "Del Food Type", "Exit"}, null);
        this.mainList.addCommand(this.nextCommand);
        this.mainList.addCommand(this.backCommand);
        this.mainList.setCommandListener((CommandListener)this);
        System.out.println("mainList was created");
        this.addCaloriesForm = new Form("Add Calories");
        this.foodTypesCG = new ChoiceGroup("Food", 1, this.types, null);
        this.amountCG = new ChoiceGroup("Amount", 1, new String[]{"0.25", "0.5", "0.75", "1.0", "1.25", "1.5", "1.75", "2.0", "2.25", "2.5"}, null);
        this.addCaloriesForm.append((Item)this.foodTypesCG);
        this.addCaloriesForm.append((Item)this.amountCG);
        this.addCaloriesForm.addCommand(this.addCommand);
        this.addCaloriesForm.addCommand(this.backCommand);
        this.addCaloriesForm.setCommandListener((CommandListener)this);
        System.out.println("addCaloriesForm was created");
        this.resetForm = new Form("Reset");
        this.resetSI = new StringItem("The result of this action", " All the calories data shell be deleted");
        this.resetForm.append((Item)this.resetSI);
        this.resetForm.addCommand(this.delCommand);
        this.resetForm.addCommand(this.backCommand);
        this.resetForm.setCommandListener((CommandListener)this);
        System.out.println("resetForm was created");
        this.addTypeForm = new Form("Add Food Type");
        this.nameTF = new TextField("Food name", "", 14, 0);
        this.foodDrinkCG = new ChoiceGroup("", 1, new String[]{"100gr", "100ml"}, null);
        this.caloriesTF = new TextField("Calories in 100gr/ml", "", 5, 2);
        this.addTypeForm.append((Item)this.nameTF);
        this.addTypeForm.append((Item)this.foodDrinkCG);
        this.addTypeForm.append((Item)this.caloriesTF);
        this.addTypeForm.addCommand(this.addCommand);
        this.addTypeForm.addCommand(this.backCommand);
        this.addTypeForm.setCommandListener((CommandListener)this);
        System.out.println("addTypeForm was created");
        this.reportsForm = new Form("Reports");
        this.reportsCG = new ChoiceGroup("Report for", 1, new String[]{"today (total)", "yesterday (total)", "last 2 days (avg)", "last 3 days (avg)", "last 4 days (avg)"}, null);
        this.reportsForm.append((Item)this.reportsCG);
        this.reportsForm.addCommand(this.nextCommand);
        this.reportsForm.addCommand(this.backCommand);
        this.reportsForm.setCommandListener((CommandListener)this);
        System.out.println("reportsForm was created");
        this.textualReportForm = new Form("Textual Report");
        this.textualReportForm.addCommand(this.mainCommand);
        this.textualReportForm.addCommand(this.backCommand);
        this.textualReportForm.setCommandListener((CommandListener)this);
        System.out.println("textualReportForm was created");
        this.delTypeForm = new Form("Del Food Type");
        this.foodTypesCGCopy = new ChoiceGroup("", 1, this.types, null);
        this.delTypeForm.append((Item)this.foodTypesCGCopy);
        this.delTypeForm.addCommand(this.delCommand);
        this.delTypeForm.addCommand(this.backCommand);
        this.delTypeForm.setCommandListener((CommandListener)this);
        System.out.println("delTypeForm was created");
    }

    public void itemStateChanged(Item item) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.openingForm) {
            if (c == this.nextCommand) {
                this.display.setCurrent((Displayable)this.mainList);
            } else if (c == this.helpCommand) {
                this.display.setCurrent((Displayable)this.helpForm);
            }
        } else if (d == this.helpForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.openingForm);
            }
        } else if (d == this.mainList) {
            if (c == this.nextCommand) {
                if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Add Calories") && this.foodTypesCG.size() > 0) {
                    this.foodTypesCG.setSelectedIndex(0, true);
                    this.amountCG.setSelectedIndex(3, true);
                    this.display.setCurrent((Displayable)this.addCaloriesForm);
                } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Reports")) {
                    this.display.setCurrent((Displayable)this.reportsForm);
                } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Reset")) {
                    this.display.setCurrent((Displayable)this.resetForm);
                } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Del Food Type")) {
                    this.display.setCurrent((Displayable)this.delTypeForm);
                } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Add Food Type")) {
                    this.display.setCurrent((Displayable)this.addTypeForm);
                } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Exit")) {
                    this.exit();
                }
            } else if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.openingForm);
            }
        } else if (d == this.resetForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.mainList);
            } else if (c == this.delCommand) {
                try {
                    this.javaDietEngine.delAllCaloris();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.display.setCurrent((Displayable)this.mainList);
            }
        } else if (d == this.addCaloriesForm) {
            if (c == this.addCommand) {
                try {
                    long time = new Date().getTime();
                    String typeName = this.foodTypesCG.getString(this.foodTypesCG.getSelectedIndex());
                    int sum = (this.amountCG.getSelectedIndex() + 1) * this.javaDietEngine.getCaloriesPerUnitByName(typeName) / 4;
                    CaloriesConsumption newCalories = new CaloriesConsumption(time, typeName, sum);
                    this.javaDietEngine.addCaloriesConsumption(newCalories);
                    this.alertMessage.setString("calories adding succeeded");
                    this.alertMessage.setTimeout(2000);
                    this.alertMessage.setType(AlertType.INFO);
                    this.display.setCurrent((Displayable)this.mainList);
                    this.display.setCurrent((Displayable)this.alertMessage);
                }
                catch (Exception e) {
                    this.alertMessage.setString("calories adding failed");
                    this.alertMessage.setTimeout(2000);
                    this.alertMessage.setType(AlertType.ERROR);
                    this.display.setCurrent((Displayable)this.mainList);
                    this.display.setCurrent((Displayable)this.alertMessage);
                    e.printStackTrace();
                }
            } else if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.mainList);
            }
        } else if (d == this.delTypeForm) {
            if (c == this.delCommand) {
                System.out.println("Del was pressed");
                int temp = this.foodTypesCGCopy.getSelectedIndex();
                System.out.println("The index of the type that was selected is " + temp);
                System.out.println("In foodTypesCG the type to be deleted is " + this.foodTypesCG.getString(temp));
                System.out.println("In foodTypesCGCopy the type to be deleted is " + this.foodTypesCGCopy.getString(temp));
                this.javaDietEngine.removeTypeByName(this.foodTypesCG.getString(temp));
                this.foodTypesCG.delete(temp);
                this.foodTypesCGCopy.delete(temp);
                this.display.setCurrent((Displayable)this.mainList);
            } else if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.mainList);
            }
        } else if (d == this.addTypeForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.mainList);
            } else if (c == this.addCommand) {
                try {
                    this.javaDietEngine.addType(new FoodType(this.nameTF.getString(), Integer.parseInt(this.caloriesTF.getString()), this.foodDrinkCG.getSelectedIndex() == 1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.display.setCurrent((Displayable)this.mainList);
                this.nameTF.setString("");
                this.caloriesTF.setString("");
                this.foodDrinkCG.setSelectedIndex(0, true);
            }
        } else if (d == this.reportsForm) {
            if (c == this.nextCommand) {
                this.initTextualReportForm();
                this.display.setCurrent((Displayable)this.textualReportForm);
            } else if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.mainList);
            }
        } else if (d == this.textualReportForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.reportsForm);
            } else if (c == this.mainCommand) {
                this.display.setCurrent((Displayable)this.mainList);
            }
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        System.out.println("in startApp()");
    }

    public void pauseApp() {
        System.out.println("in pause()");
    }

    public void destroyApp(boolean cond) {
        this.display = null;
        this.openingForm = null;
        this.helpForm = null;
        this.resetForm = null;
        this.reportsForm = null;
        this.textualReportForm = null;
        this.graphicReportForm = null;
        this.addCaloriesForm = null;
        this.addTypeForm = null;
        this.delTypeForm = null;
        this.img1 = null;
        this.img2 = null;
        this.imgItem1 = null;
        this.imgItem2 = null;
        this.graphImgItem = null;
        this.mainList = null;
        this.resetSI = null;
        this.openingSI = null;
        this.helpSI = null;
        this.nameTF = null;
        this.caloriesTF = null;
        this.calendar = null;
        this.graphicReportCanvas = null;
        this.helpCommand = null;
        this.nextCommand = null;
        this.backCommand = null;
        this.saveCommand = null;
        this.delCommand = null;
        this.addCommand = null;
        this.okCommand = null;
        this.mainCommand = null;
        this.types = null;
        this.javaDietEngine = null;
        this.foodTypesCG = null;
        this.foodTypesCGCopy = null;
        this.reportsCG = null;
        this.amountCG = null;
        this.foodDrinkCG = null;
        this.alertMessage = null;
        this.animationThread = null;
        this.reportSI = null;
    }

    public void initTextualReportForm() {
        int sum2;
        int numOfItemsToRemove = this.textualReportForm.size();
        int i = 0;
        while (i < numOfItemsToRemove) {
            this.textualReportForm.delete(i);
            ++i;
        }
        int index = this.reportsCG.getSelectedIndex();
        Calendar current = Calendar.getInstance();
        long now = current.getTime().getTime();
        long other = 0L;
        if (index == 0 || index == 1 || index == 2 || index == 3 || index == 4) {
            other = now - (long)current.get(14) - (long)(current.get(13) * 1000) - (long)(current.get(10) * 3600 * 1000);
            if (current.get(9) == 1) {
                other -= 43200000L;
            }
        }
        if (index == 1 || index == 2) {
            other -= 86400000L;
        }
        if (index == 3) {
            other -= 172800000L;
        }
        if (index == 4) {
            other -= 259200000L;
        }
        if (index == 0) {
            int sum = this.javaDietEngine.getCaloriesConsumptions(other);
            this.reportSI = new StringItem("Total today calories", " " + sum);
            this.textualReportForm.append((Item)this.reportSI);
        }
        if (index == 1) {
            sum2 = this.javaDietEngine.getCaloriesConsumptions(other);
            int sum1 = this.javaDietEngine.getCaloriesConsumptions(other + 86400000L);
            this.reportSI = new StringItem("Total yesterday calories", " " + (sum2 - sum1));
            this.textualReportForm.append((Item)this.reportSI);
        }
        if (index == 2) {
            sum2 = this.javaDietEngine.getCaloriesConsumptions(other);
            this.reportSI = new StringItem("Average calories during the last two days (yesterday & today)", " " + sum2 / 2);
            this.textualReportForm.append((Item)this.reportSI);
        }
        if (index == 3) {
            sum2 = this.javaDietEngine.getCaloriesConsumptions(other);
            this.reportSI = new StringItem("Average calories during the last three days ", " " + sum2 / 3);
            this.textualReportForm.append((Item)this.reportSI);
        }
        if (index == 4) {
            sum2 = this.javaDietEngine.getCaloriesConsumptions(other);
            this.reportSI = new StringItem("Average calories during the last four days ", " " + sum2 / 4);
            this.textualReportForm.append((Item)this.reportSI);
        }
    }

    static /* synthetic */ String[] access$302(JavaDiet x0, String[] x1) {
        x0.types = x1;
        return x1;
    }

    class JavaDietEngine {
        private RecordStore typesRS = RecordStore.openRecordStore((String)"foodTypesRS", (boolean)true);
        private RecordStore caloriesRS = RecordStore.openRecordStore((String)"caloriesRS", (boolean)true);
        private Vector typesVec = new Vector();

        JavaDietEngine() throws Exception {
            this.initTypesVec();
            this.updateTypesArray();
        }

        int getCaloriesPerUnitByName(String str) {
            int comma = str.lastIndexOf(44);
            int sum = Integer.parseInt(str.substring(comma + 1, str.length() - 3));
            System.out.println("calories of " + str + " is " + sum);
            return sum;
        }

        public int getCaloriesConsumptions(long since) {
            int result = 0;
            RecordEnumeration recordEnumeration = null;
            try {
                recordEnumeration = this.caloriesRS.enumerateRecords(null, null, true);
                int tempId = 0;
                CaloriesConsumption temp = null;
                while (recordEnumeration.hasNextElement()) {
                    tempId = recordEnumeration.nextRecordId();
                    System.out.println("tempId=" + tempId);
                    byte[] data = this.caloriesRS.getRecord(tempId);
                    temp = new CaloriesConsumption(data);
                    if (temp.getTime() <= since) continue;
                    result += temp.getSum();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        void delAllCaloris() throws Exception {
            System.out.println("within delAllCaloris()");
            this.caloriesRS.closeRecordStore();
            RecordStore.deleteRecordStore((String)"caloriesRS");
            this.caloriesRS = RecordStore.openRecordStore((String)"caloriesRS", (boolean)true);
        }

        void addCaloriesConsumption(CaloriesConsumption newCaloriesConsumption) throws Exception {
            byte[] vec = newCaloriesConsumption.toBytes();
            this.caloriesRS.addRecord(vec, 0, vec.length);
        }

        void updateTypesArray() {
            String[] vec = new String[this.typesVec.size()];
            FoodType temp = null;
            int i = 0;
            while (i < vec.length) {
                temp = (FoodType)this.typesVec.elementAt(i);
                vec[i] = temp.isDrink() ? temp.toString() : temp.toString();
                ++i;
            }
            JavaDiet.access$302(JavaDiet.this, vec);
        }

        void initTypesVec() {
            RecordEnumeration recordEnumeration = null;
            try {
                recordEnumeration = this.typesRS.enumerateRecords(null, null, false);
                int tempId = 0;
                while (recordEnumeration.hasNextElement()) {
                    tempId = recordEnumeration.nextRecordId();
                    byte[] data = this.typesRS.getRecord(tempId);
                    this.typesVec.addElement(new FoodType(data));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void addType(FoodType type) throws Exception {
            byte[] temp = type.toBytes();
            int idTemp = this.typesRS.addRecord(temp, 0, temp.length);
            type.setId(idTemp);
            this.typesVec.addElement(type);
            String str = null;
            str = type.isDrink() ? type.toString() : type.toString();
            JavaDiet.this.foodTypesCG.append(str, null);
            JavaDiet.this.foodTypesCGCopy.append(str, null);
        }

        void removeTypeByName(String str) {
            int recordId = 0;
            FoodType temp = null;
            int i = 0;
            while (i < this.typesVec.size()) {
                System.out.println("i=" + i);
                temp = (FoodType)this.typesVec.elementAt(i);
                System.out.println("temp=" + temp);
                System.out.println("str=" + str);
                if (temp.toString().equals(str)) {
                    recordId = temp.getId();
                    break;
                }
                ++i;
            }
            try {
                System.out.println("typesRS.deleteRecord(" + recordId + ")");
                this.typesRS.deleteRecord(recordId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AnimationThread
    extends Thread {
        private boolean goOn = true;
        private boolean pause = false;
        private int pic = 1;

        AnimationThread() {
        }

        public void run() {
            while (this.goOn) {
                try {
                    if (this.pause) {
                        try {
                            Form form = JavaDiet.this.openingForm;
                            synchronized (form) {
                                JavaDiet.this.openingForm.wait();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Thread.sleep(400L);
                    if (this.pic == 1) {
                        JavaDiet.this.openingForm.set(0, (Item)JavaDiet.this.imgItem2);
                    } else {
                        JavaDiet.this.openingForm.set(0, (Item)JavaDiet.this.imgItem1);
                    }
                    this.pic *= -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void startAnimation() {
            this.start();
        }

        public void pauseAnimation() {
            this.pause = true;
        }

        public void resumeAnimation() {
            this.pause = false;
            Form form = JavaDiet.this.openingForm;
            synchronized (form) {
                JavaDiet.this.openingForm.notify();
            }
        }

        public void stopAnimation() {
            this.goOn = false;
        }
    }
}

